uniform sampler2D	u_ColorMap;
const vec4			LUMINANCE_VECTOR = vec4(0.2125, 0.7154, 0.0721, 0.0);
void	main()
{
	vec2 st = gl_FragCoord.st;
	st *= gfx_FBufScale;

	 
	st *= vec2(4.0, 4.0);

	st *= gfx_NPOTScale;


	vec4 color = texture2D(u_ColorMap, st);

	float L = dot(LUMINANCE_VECTOR, color);
	 
	L = pow(L, 1.32);

	float T = clamp(L - 0.71, 0.0, 1.0);

	color.rgb *= T;

	gl_FragColor = color;
}
