attribute vec4		attr_Position;
#if defined(gfx_VertexSkinning)
attribute vec4		attr_BoneIndexes;
attribute vec4		attr_BoneWeights;
uniform int			u_VertexSkinning;
uniform mat4		u_BoneMatrix[MAX_GLSL_BONES];
#endif

uniform mat4		u_ModelViewProjectionMatrix;

void	main()
{
#if defined(gfx_VertexSkinning)
	if(bool(u_VertexSkinning))
	{
		vec4 vertex = vec4(0.0);

		for(int i = 0; i < 4; i++)
		{
			int boneIndex = int(attr_BoneIndexes[i]);
			float boneWeight = attr_BoneWeights[i];
			mat4  boneMatrix = u_BoneMatrix[boneIndex];

			vertex += (boneMatrix * attr_Position) * boneWeight;
		}

		gl_Position = u_ModelViewProjectionMatrix * vertex;
	}
	else
#endif
	{

		gl_Position = u_ModelViewProjectionMatrix * attr_Position;
	}
}
