uniform sampler2D	u_ColorMap;  
uniform sampler2D	u_DepthMap;
uniform vec3		u_ViewOrigin;
uniform vec4		u_FogDistanceVector;
uniform vec4		u_FogDepthVector;
uniform vec4		u_Color;
uniform mat4		u_ViewMatrix;
uniform mat4		u_UnprojectMatrix;

void	main()
{

	vec2 st = gl_FragCoord.st * gfx_FBufScale;

	st *= gfx_NPOTScale;

	 
	float depth = texture2D(u_DepthMap, st).r;
	vec4 P = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depth, 1.0);
	P.xyz /= P.w;

#if defined(COMPAT_ET)
	 
	st.s = dot(P.xyz, u_FogDistanceVector.xyz) + u_FogDistanceVector.w;
	 
	st.t = 1.0;

	gl_FragColor = u_Color * texture2D(u_ColorMap, st);
#else
	vec4 Pcam = u_ViewMatrix * vec4(P.xyz, 1.0);
	float vertexDistanceToCamera = -Pcam.z;
	 
	float fogExponent = vertexDistanceToCamera * u_FogDepthVector.x;
	 
	float fogFactor = exp2(-abs(fogExponent));
	 
	gl_FragColor = vec4(u_Color.rgb, fogFactor);
#endif
}
