attribute vec4		attr_Position;
attribute vec4		attr_TexCoord0;
attribute vec3		attr_Normal;
attribute vec4		attr_Color;
attribute vec4		attr_Position2;
attribute vec3		attr_Normal2;
attribute vec4		attr_BoneIndexes;
attribute vec4		attr_BoneWeights;
uniform int			u_VertexSkinning;
uniform mat4		u_BoneMatrix[MAX_GLSL_BONES];
uniform float		u_VertexInterpolation;
uniform vec3		u_ViewOrigin;
uniform float		u_Time;
uniform vec4		u_ColorModulate;
uniform vec4		u_Color;
uniform mat4		u_ModelMatrix;
uniform mat4		u_ModelViewProjectionMatrix;
uniform vec4		u_FogDistanceVector;
uniform vec4		u_FogDepthVector;
uniform float		u_FogEyeT;
varying vec3		var_Position;
varying vec2		var_Tex;
varying vec4		var_Color;

void	main()
{
	vec4 position = vec4(0.0);
	vec3 normal = vec3(0.0);

#if defined(USE_VERTEX_SKINNING)
	{
		for(int i = 0; i < 4; i++)
		{
			int boneIndex = int(attr_BoneIndexes[i]);
			float boneWeight = attr_BoneWeights[i];
			mat4  boneMatrix = u_BoneMatrix[boneIndex];

			position += (boneMatrix * attr_Position) * boneWeight;
			normal += (boneMatrix * vec4(attr_Normal, 0.0)).xyz * boneWeight;
		}
	}
#elif defined(USE_VERTEX_ANIMATION)
	{
		if(u_VertexInterpolation > 0.0)
		{
			VertexAnimation_P_N(attr_Position, attr_Position2,
								attr_Normal, attr_Normal2,
								u_VertexInterpolation,
								position, normal);
		}
		else
		{
			position = attr_Position;
			normal = attr_Normal;
		}
	}
#else
	{
		position = attr_Position;
		normal = attr_Normal;
	}
#endif

#if defined(USE_DEFORM_VERTEXES)
	position = DeformPosition2(	position,
								normal,
								attr_TexCoord0.st,
								u_Time);
#endif

	gl_Position = u_ModelViewProjectionMatrix * position;

	var_Position = (u_ModelMatrix * position).xyz;

	 
	float s = dot(position.xyz, u_FogDistanceVector.xyz) + u_FogDistanceVector.w;
	float t = dot(position.xyz, u_FogDepthVector.xyz) + u_FogDepthVector.w;

	 
#if defined(EYE_OUTSIDE)
	if(t < 1.0)
	{
		t = 1.0 / 32;	 
	}
	else
	{
		t = 1.0 / 32 + 30.0 / 32 * t / (t - u_FogEyeT);	 
	}
#else
	if(t < 0)
	{
		t = 1.0 / 32;	 
	}
	else
	{
		t = 31.0 / 32;
	}
#endif

	var_Tex = vec2(s, t);

	var_Color = /* attr_Color * u_ColorModulate + */ u_Color;
}
