uniform sampler2D	u_DiffuseMap;
uniform sampler2D	u_NormalMap;
uniform sampler2D	u_SpecularMap;
uniform sampler2D	u_AttenuationMapXY;
uniform sampler2D	u_AttenuationMapZ;
uniform sampler2D	u_ShadowMap0;
uniform sampler2D	u_ShadowMap1;
uniform sampler2D	u_ShadowMap2;
uniform sampler2D	u_ShadowMap3;
uniform sampler2D	u_ShadowMap4;
uniform vec3		u_ViewOrigin;
uniform vec3		u_LightDir;
uniform vec3		u_LightColor;
uniform float		u_LightRadius;
uniform float		u_LightScale;
uniform	float		u_LightWrapAround;
uniform int			u_ShadowCompare;
uniform mat4		u_ShadowMatrix[MAX_SHADOWMAPS];
uniform vec4		u_ShadowParallelSplitDistances;
uniform float       u_ShadowTexelSize;
uniform float       u_ShadowBlur;
uniform mat4		u_ModelMatrix;
uniform mat4		u_ViewMatrix;
uniform int         u_PortalClipping;
uniform vec4		u_PortalPlane;
varying vec4		var_Position;
varying vec4		var_TexDiffuse;
varying vec4		var_TexNormal;
#if defined(gfx_NormalMapping)
varying vec2		var_TexSpecular;
#endif
varying vec4		var_TexAtten;
varying vec4		var_Tangent;
varying vec4		var_Binormal;
varying vec4		var_Normal;

#if defined(PCSS)
float SumBlocker(vec4 shadowVert, float vertexDistance, float filterWidth, float samples)
{
	float stepSize = 2.0 * filterWidth / samples;

	float blockerCount = 0.0;
    float blockerSum = 0.0;

	for(float i = -filterWidth; i < filterWidth; i += stepSize)
	{
		for(float j = -filterWidth; j < filterWidth; j += stepSize)
		{
			float shadowDistance = texture2DProj(u_ShadowMap, vec3(shadowVert.xy + vec2(i, j), shadowVert.w)).x;
			
			if(vertexDistance > shadowDistance)
			{
				blockerCount += 1.0;
				blockerSum += shadowDistance;
			}
		}
	}

	float result;
	if(blockerCount > 0.0)
		result = blockerSum / blockerCount;
	else
		result = 0.0;

	return result;
}

float EstimatePenumbra(float vertexDistance, float blocker)
{
	float penumbra;

	if(blocker == 0.0)
		penumbra = 0.0;
	else
		penumbra = ((vertexDistance - blocker) * u_LightRadius) / blocker;

	return penumbra;
}
#endif

void	main()
{
	if(bool(u_PortalClipping))
	{
		float dist = dot(var_Position.xyz, u_PortalPlane.xyz) - u_PortalPlane.w;
		if(dist < 0.0)
		{
			discard;
			return;
		}
	}

	float shadow = 1.0;

	if(var_TexAtten.q <= 0.0)
	{
		discard;
		return;
	}

#if defined(VSM)
	if(bool(u_ShadowCompare))
	{
		vec4 shadowVert;
		vec4 shadowMoments;

		 
		vec4 Pcam = u_ViewMatrix * vec4(var_Position.xyz, 1.0);
		float vertexDistanceToCamera = -Pcam.z;

#if defined(gfx_ParallelShadowSplits_1)
		if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.x)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
		else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[1] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap1, shadowVert.xyw);
			#endif
		}
#elif defined(gfx_ParallelShadowSplits_2)
		if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.x)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.y)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[1] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap1, shadowVert.xyw);
			#endif

		}
		else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[2] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap2, shadowVert.xyw);
			#endif
		}
#elif defined(gfx_ParallelShadowSplits_3)
		if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.x)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.y)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[1] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap1, shadowVert.xyw);
			#endif

		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.z)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[2] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap2, shadowVert.xyw);
			#endif
		}
		else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[3] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap3, shadowVert.xyw);
			#endif
		}
#elif defined(gfx_ParallelShadowSplits_4)
		if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.x)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.y)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[1] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap1, shadowVert.xyw);
			#endif

		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.z)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[2] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap2, shadowVert.xyw);
			#endif
		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.w)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 1.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[3] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap3, shadowVert.xyw);
			#endif
		}
		else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[4] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap4, shadowVert.xyw);
			#endif
		}
#else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
#endif

		 

		const float	SHADOW_BIAS = 0.001;
		float vertexDistance = shadowVert.z - SHADOW_BIAS;

		#if defined(VSM_CLAMP)
		 
		shadowMoments = 2.0 * (shadowMoments - 0.5);
		#endif

		float shadowDistance = shadowMoments.r;
		float shadowDistanceSquared = shadowMoments.a;

		 
		shadow = vertexDistance <= shadowDistance ? 1.0 : 0.0;

		 
		float E_x2 = shadowDistanceSquared;
		float Ex_2 = shadowDistance * shadowDistance;

		 
		float variance = max(E_x2 - Ex_2, VSM_EPSILON);
		 

		float mD = shadowDistance - vertexDistance;
		float mD_2 = mD * mD;
		float p = variance / (variance + mD_2);

		#if defined(gfx_LightBleedReduction)
		p = smoothstep(gfx_LightBleedReduction, 1.0, p);
		#endif

		#if defined(DEBUG_VSM)
		#extension GL_EXT_gpu_shader4 : enable
		gl_FragColor.r = (DEBUG_VSM & 1) != 0 ? variance : 0.0;
		gl_FragColor.g = (DEBUG_VSM & 2) != 0 ? mD_2 : 0.0;
		gl_FragColor.b = (DEBUG_VSM & 4) != 0 ? p : 0.0;
		gl_FragColor.a = 1.0;
		return;
		#else
		shadow = max(shadow, p);
		#endif
	}

	if(shadow <= 0.0)
	{
		discard;
		return;
	}
	else
#elif defined(ESM)
	if(bool(u_ShadowCompare))
	{
		/*
		#if defined(PCF_2X2)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 2.0);
		#elif defined(PCF_3X3)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 3.0);
		#elif defined(PCF_4X4)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 4.0);
		#elif defined(PCF_5X5)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 5.0);
		#elif defined(PCF_6X6)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 6.0);
		#else
		 
		vec4 shadowMoments = texture2DProj(u_ShadowMap, shadowVert.xyw);
		#endif
		*/

		vec4 shadowVert;
		vec4 shadowMoments;

		 
		vec4 Pcam = u_ViewMatrix * vec4(var_Position.xyz, 1.0);
		float vertexDistanceToCamera = -Pcam.z;

#if defined(gfx_ParallelShadowSplits_1)
		if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.x)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
		else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[1] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap1, shadowVert.xyw);
			#endif
		}
#elif defined(gfx_ParallelShadowSplits_2)
		if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.x)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.y)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[1] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap1, shadowVert.xyw);
			#endif

		}
		else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[2] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap2, shadowVert.xyw);
			#endif
		}
#elif defined(gfx_ParallelShadowSplits_3)
		if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.x)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.y)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[1] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap1, shadowVert.xyw);
			#endif

		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.z)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[2] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap2, shadowVert.xyw);
			#endif
		}
		else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[3] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap3, shadowVert.xyw);
			#endif
		}
#elif defined(gfx_ParallelShadowSplits_4)
		if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.x)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.y)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 1.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[1] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap1, shadowVert.xyw);
			#endif

		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.z)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(0.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[2] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap2, shadowVert.xyw);
			#endif
		}
		else if(vertexDistanceToCamera < u_ShadowParallelSplitDistances.w)
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 1.0, 0.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[3] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap3, shadowVert.xyw);
			#endif
		}
		else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[4] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap4, shadowVert.xyw);
			#endif
		}
#else
		{
			#if defined(gfx_ShowParallelShadowSplits)
			gl_FragColor = vec4(1.0, 0.0, 1.0, 1.0);
			return;
			#else
			shadowVert = u_ShadowMatrix[0] * vec4(var_Position.xyz, 1.0);
			shadowMoments = texture2DProj(u_ShadowMap0, shadowVert.xyw);
			#endif
		}
#endif

		 

		const float	SHADOW_BIAS = 0.001;
		float vertexDistance = shadowVert.z - SHADOW_BIAS;

		float shadowDistance = shadowMoments.a;

		 
		 
		shadow = clamp(exp(gfx_OverDarkeningFactor * (shadowDistance - vertexDistance)), 0.0, 1.0);
		 

		#if defined(DEBUG_ESM)
		#extension GL_EXT_gpu_shader4 : enable
		gl_FragColor.r = (DEBUG_ESM & 1) != 0 ? shadowDistance : 0.0;
		gl_FragColor.g = (DEBUG_ESM & 2) != 0 ? -(shadowDistance - vertexDistance) : 0.0;
		gl_FragColor.b = (DEBUG_ESM & 4) != 0 ? shadow : 0.0;
		gl_FragColor.a = 1.0;
		return;
		#endif
	}

	if(shadow <= 0.0)
	{
		discard;
		return;
	}
	else
#endif
	{
		 
		vec3 L = u_LightDir;

#if defined(gfx_NormalMapping)
		 
		vec3 V = normalize(u_ViewOrigin - var_Position.xyz);

		 
		vec3 H = normalize(L + V);

		 
		vec3 N = 2.0 * (texture2D(u_NormalMap, var_TexNormal.st).xyz - 0.5);
		#if defined(gfx_NormalScale)
		N.z *= gfx_NormalScale;
		normalize(N);
		#endif

		 
		mat3 tangentToWorldMatrix;
		if(gl_FrontFacing)
			tangentToWorldMatrix = mat3(-var_Tangent.xyz, -var_Binormal.xyz, -var_Normal.xyz);
		else
			tangentToWorldMatrix = mat3(var_Tangent.xyz, var_Binormal.xyz, var_Normal.xyz);

		 
		N = tangentToWorldMatrix * N;
#else
		vec3 N;
		if(gl_FrontFacing)
			N = -normalize(var_Normal.xyz);
		else
			N = normalize(var_Normal.xyz);
#endif

		 
#if defined(gfx_WrapAroundLighting)
		float NL = clamp(dot(N, L) + u_LightWrapAround, 0.0, 1.0) / clamp(1.0 + u_LightWrapAround, 0.0, 1.0);
#else
		float NL = clamp(dot(N, L), 0.0, 1.0);
#endif

		 
		vec4 diffuse = texture2D(u_DiffuseMap, var_TexDiffuse.st);
		diffuse.rgb *= u_LightColor * NL;

#if defined(gfx_NormalMapping)
		 
		vec3 specular = texture2D(u_SpecularMap, var_TexSpecular).rgb * u_LightColor * pow(clamp(dot(N, H), 0.0, 1.0), gfx_SpecularExponent) * gfx_SpecularScale;
#endif

		 
		vec4 color = diffuse;
#if defined(gfx_NormalMapping)
		color.rgb += specular;
#endif
		color.rgb *= u_LightScale;
		color.rgb *= shadow;

		color.r *= var_TexDiffuse.p;
		color.gb *= var_TexNormal.pq;

		gl_FragColor = color;
	}
}
