uniform sampler2D	u_LightMap;
uniform sampler2D	u_DiffuseMap;
uniform sampler2D	u_NormalMap;
uniform sampler2D	u_SpecularMap;
uniform int			u_AlphaTest;
uniform vec3		u_ViewOrigin;
uniform vec3        u_AmbientColor;
uniform int			u_ParallaxMapping;
uniform float		u_DepthScale;

varying vec2		var_TexDiffuse;
#if defined(gfx_NormalMapping)
varying vec2		var_TexNormal;
varying vec2		var_TexSpecular;
#endif

void	main()
{
	vec2 texDiffuse = var_TexDiffuse.st;

#if defined(gfx_NormalMapping)
	vec2 texNormal = var_TexNormal.st;
	vec2 texSpecular = var_TexSpecular.st;
#endif

		texNormal.st += texOffset;
		texDiffuse.st += texOffset;
		texSpecular.st += texOffset;
	}
#endif

#if 1
	vec4 diffuse = texture2D(u_DiffuseMap, texDiffuse);
	if(u_AlphaTest == ATEST_GT_0 && diffuse.a <= 0.0)
	{
		discard;
		return;
	}
	else if(u_AlphaTest == ATEST_LT_128 && diffuse.a >= 0.5)
	{
		discard;
		return;
	}
	else if(u_AlphaTest == ATEST_GE_128 && diffuse.a < 0.5)
	{
		discard;
		return;
	}
#endif

	vec2 fragCoord = gl_FragCoord.st * gfx_FBufScale;

	fragCoord *= gfx_NPOTScale;

	vec4 light = texture2D(u_LightMap, fragCoord);
	 

	 
	vec4 color = vec4(u_AmbientColor.rgb + (diffuse.rgb * light.rgb), diffuse.a);
	 
	 

	const vec4 LUMINANCE_VECTOR = vec4(0.2125, 0.7154, 0.0721, 0.0);
	float Y = dot(LUMINANCE_VECTOR, light);

#if defined(gfx_NormalMapping)
	vec3 specular = texture2D(u_SpecularMap, texSpecular).rgb ;

	specular *= Y;
	specular *= light.rgb;
	 
	 
	specular *= light.a; 
	specular *= gfx_SpecularScale; 
	color.rgb += specular;
	 
#endif

	gl_FragColor = color;
}
