uniform sampler2D	u_DiffuseMap;
uniform sampler2D	u_NormalMap;
uniform sampler2D	u_SpecularMap;
uniform sampler2D	u_AttenuationMapXY;
uniform sampler2D	u_AttenuationMapZ;
uniform sampler2D	u_ShadowMap;
uniform vec3		u_ViewOrigin;
uniform vec3		u_LightOrigin;
uniform vec3		u_LightColor;
uniform float		u_LightRadius;
uniform float		u_LightScale;
uniform	float		u_LightWrapAround;
uniform int			u_ShadowCompare;
uniform float       u_ShadowTexelSize;
uniform float       u_ShadowBlur;
uniform mat4		u_ModelMatrix;
uniform int         u_PortalClipping;
uniform vec4		u_PortalPlane;
varying vec4		var_Position;
varying vec4		var_TexDiffuse;
varying vec4		var_TexNormal;
#if defined(gfx_NormalMapping)
varying vec2		var_TexSpecular;
#endif
varying vec4		var_TexAtten;
varying vec4		var_Tangent;
varying vec4		var_Binormal;
varying vec4		var_Normal;

#if defined(PCSS)
float SumBlocker(vec4 shadowVert, float vertexDistance, float filterWidth, float samples)
{
	float stepSize = 2.0 * filterWidth / samples;

	float blockerCount = 0.0;
    float blockerSum = 0.0;

	for(float i = -filterWidth; i < filterWidth; i += stepSize)
	{
		for(float j = -filterWidth; j < filterWidth; j += stepSize)
		{
			float shadowDistance = texture2DProj(u_ShadowMap, vec3(shadowVert.xy + vec2(i, j), shadowVert.w)).x;
			 

			 

			if(vertexDistance > shadowDistance)
			{
				blockerCount += 1.0;
				blockerSum += shadowDistance;
			}
		}
	}

	float result;
	if(blockerCount > 0.0)
		result = blockerSum / blockerCount;
	else
		result = 0.0;

	return result;
}

float EstimatePenumbra(float vertexDistance, float blocker)
{
	float penumbra;

	if(blocker == 0.0)
		penumbra = 0.0;
	else
		penumbra = ((vertexDistance - blocker) * u_LightRadius) / blocker;

	return penumbra;
}
#endif

#if defined(VSM) || defined(ESM)
vec4 PCF(vec4 shadowVert, float filterWidth, float samples)
{
	 
	float stepSize = 2.0 * filterWidth / samples;

	vec4 moments = vec4(0.0, 0.0, 0.0, 0.0);
	for(float i = -filterWidth; i < filterWidth; i += stepSize)
	{
		for(float j = -filterWidth; j < filterWidth; j += stepSize)
		{
			 
			moments += texture2D(u_ShadowMap, shadowVert.xy / shadowVert.w + vec2(i, j));
		}
	}

	 
	moments *= (1.0 / (samples * samples));
	return moments;
}
#endif

void	main()
{
	if(bool(u_PortalClipping))
	{
		float dist = dot(var_Position.xyz, u_PortalPlane.xyz) - u_PortalPlane.w;
		if(dist < 0.0)
		{
			discard;
			return;
		}
	}

	float shadow = 1.0;

	if(var_TexAtten.q <= 0.0)
	{
		discard;
		return;
	}

#if defined(VSM)
	if(bool(u_ShadowCompare))
	{
		vec4 shadowVert;	 
		shadowVert.x = var_Position.w;
		shadowVert.y = var_Tangent.w;
		shadowVert.z = var_Binormal.w;
		shadowVert.w = var_Normal.w;

		 
		vec3 I = var_Position.xyz - u_LightOrigin;

		const float	SHADOW_BIAS = 0.001;
		float vertexDistance = length(I) / u_LightRadius - SHADOW_BIAS;

		#if defined(PCF_2X2)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 2.0);
		#elif defined(PCF_3X3)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 3.0);
		#elif defined(PCF_4X4)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 4.0);
		#elif defined(PCF_5X5)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 5.0);
		#elif defined(PCF_6X6)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 6.0);
		#elif defined(PCSS)

		 
		float blockerSearchWidth = u_ShadowTexelSize * u_LightRadius / vertexDistance;
		float blockerSamples = 6.0;  
		float blocker = SumBlocker(shadowVert, vertexDistance, blockerSearchWidth, blockerSamples);

		#if 0
		 
		gl_FragColor = vec4(blocker * 0.3, 0.0, 0.0, 1.0);
		return;
		#endif

		 
		float penumbra = EstimatePenumbra(vertexDistance, blocker);

		#if 0
		 
		gl_FragColor = vec4(0.0, 0.0, penumbra, 1.0);
		return;
		#endif

		 
		vec4 shadowMoments;
		if(penumbra > 0.0)
		{
			const float PCFsamples = 4.0;

			shadowMoments = PCF(shadowVert, penumbra, PCFsamples);
		}
		else
		{
			shadowMoments = texture2DProj(u_ShadowMap, shadowVert.xyw);
		}
		#else

		 
		vec4 shadowMoments = texture2DProj(u_ShadowMap, shadowVert.xyw);
		#endif

		#if defined(VSM_CLAMP)
		 
		shadowMoments = 2.0 * (shadowMoments - 0.5);
		#endif

		float shadowDistance = shadowMoments.r;
		float shadowDistanceSquared = shadowMoments.a;

		 
		shadow = vertexDistance <= shadowDistance ? 1.0 : 0.0;

		 
		float E_x2 = shadowDistanceSquared;
		float Ex_2 = shadowDistance * shadowDistance;

		 
		float variance = max(E_x2 - Ex_2, VSM_EPSILON);
		 

		float mD = shadowDistance - vertexDistance;
		float mD_2 = mD * mD;
		float p = variance / (variance + mD_2);

		#if defined(gfx_LightBleedReduction)
		p = smoothstep(gfx_LightBleedReduction, 1.0, p);
		#endif

		#if defined(DEBUG_VSM)
		#extension GL_EXT_gpu_shader4 : enable
		gl_FragColor.r = (DEBUG_VSM & 1) != 0 ? variance : 0.0;
		gl_FragColor.g = (DEBUG_VSM & 2) != 0 ? mD_2 : 0.0;
		gl_FragColor.b = (DEBUG_VSM & 4) != 0 ? p : 0.0;
		gl_FragColor.a = 1.0;
		return;
		#else
		shadow = max(shadow, p);
		#endif
	}

	if(shadow <= 0.0)
	{
		discard;
		return;
	}
	else
#elif defined(ESM)
	if(bool(u_ShadowCompare))
	{
		vec4 shadowVert;	 
		shadowVert.x = var_Position.w;
		shadowVert.y = var_Tangent.w;
		shadowVert.z = var_Binormal.w;
		shadowVert.w = var_Normal.w;

		 
		vec3 I = var_Position.xyz - u_LightOrigin;

		const float	SHADOW_BIAS = 0.001;
		float vertexDistance = (length(I) / u_LightRadius) * gfx_ShadowMapDepthScale;  

		#if defined(PCF_2X2)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 2.0);
		#elif defined(PCF_3X3)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 3.0);
		#elif defined(PCF_4X4)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 4.0);
		#elif defined(PCF_5X5)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 5.0);
		#elif defined(PCF_6X6)
		vec4 shadowMoments = PCF(shadowVert, u_ShadowTexelSize * u_ShadowBlur, 6.0);
		#else
		 
		vec4 shadowMoments = texture2DProj(u_ShadowMap, shadowVert.xyw);
		#endif

		float shadowDistance = shadowMoments.a;

		 
		 
		shadow = clamp(exp(gfx_OverDarkeningFactor * (shadowDistance - vertexDistance)), 0.0, 1.0);
		 

		#if defined(DEBUG_ESM)
		#extension GL_EXT_gpu_shader4 : enable
		gl_FragColor.r = (DEBUG_ESM & 1) != 0 ? shadowDistance : 0.0;
		gl_FragColor.g = (DEBUG_ESM & 2) != 0 ? -(shadowDistance - vertexDistance) : 0.0;
		gl_FragColor.b = (DEBUG_ESM & 4) != 0 ? shadow : 0.0;
		gl_FragColor.a = 1.0;
		return;
		#endif
	}

	if(shadow <= 0.0)
	{
		discard;
		return;
	}
	else
#endif
	{
		 
		vec3 L = normalize(u_LightOrigin - var_Position.xyz);

#if defined(gfx_NormalMapping)
		 
		vec3 V = normalize(u_ViewOrigin - var_Position.xyz);

		 
		vec3 H = normalize(L + V);

		 
		vec3 N = 2.0 * (texture2D(u_NormalMap, var_TexNormal.st).xyz - 0.5);
		#if defined(gfx_NormalScale)
		N.z *= gfx_NormalScale;
		normalize(N);
		#endif

		 
		mat3 tangentToWorldMatrix;
		if(gl_FrontFacing)
			tangentToWorldMatrix = mat3(-var_Tangent.xyz, -var_Binormal.xyz, -var_Normal.xyz);
		else
			tangentToWorldMatrix = mat3(var_Tangent.xyz, var_Binormal.xyz, var_Normal.xyz);

		 
		N = tangentToWorldMatrix * N;
#else
		vec3 N;
		if(gl_FrontFacing)
			N = -normalize(var_Normal.xyz);
		else
			N = normalize(var_Normal.xyz);
#endif

		 
#if defined(gfx_WrapAroundLighting)
		float NL = clamp(dot(N, L) + u_LightWrapAround, 0.0, 1.0) / clamp(1.0 + u_LightWrapAround, 0.0, 1.0);
#else
		float NL = clamp(dot(N, L), 0.0, 1.0);
#endif

		 
		vec4 diffuse = texture2D(u_DiffuseMap, var_TexDiffuse.st);
		diffuse.rgb *= u_LightColor * NL;

#if defined(gfx_NormalMapping)
		 
		vec3 specular = texture2D(u_SpecularMap, var_TexSpecular).rgb * u_LightColor * pow(clamp(dot(N, H), 0.0, 1.0), gfx_SpecularExponent) * gfx_SpecularScale;
#endif

		 
		vec3 attenuationXY = texture2DProj(u_AttenuationMapXY, var_TexAtten.xyw).rgb;
		vec3 attenuationZ  = texture2D(u_AttenuationMapZ, vec2(var_TexAtten.z + 0.5, 0.0)).rgb;  

		 
		vec4 color = diffuse;
#if defined(gfx_NormalMapping)
		color.rgb += specular;
#endif
		color.rgb *= attenuationXY;
		color.rgb *= attenuationZ;
		color.rgb *= u_LightScale;
		color.rgb *= shadow;

		color.r *= var_TexDiffuse.p;
		color.gb *= var_TexNormal.pq;

		gl_FragColor = color;
	}
}
