#extension GL_ARB_draw_buffers : enable
uniform sampler2D	u_DiffuseMap;
uniform sampler2D	u_NormalMap;
uniform sampler2D	u_SpecularMap;
uniform int			u_AlphaTest;
uniform vec3		u_ViewOrigin;
uniform vec3        u_AmbientColor;
uniform int			u_ParallaxMapping;
uniform float		u_DepthScale;
uniform mat4		u_ModelMatrix;
varying vec4		var_Position;
varying vec2		var_TexDiffuse;
#if defined(gfx_NormalMapping)
varying vec2		var_TexNormal;
varying vec2		var_TexSpecular;
varying vec4		var_Tangent;
varying vec4		var_Binormal;
#endif
varying vec4		var_Normal;

void	main()
{
#if defined(gfx_NormalMapping)
	 
	mat3 tangentToWorldMatrix;
	if(gl_FrontFacing)
		tangentToWorldMatrix = mat3(-var_Tangent.xyz, -var_Binormal.xyz, -var_Normal.xyz);
	else
		tangentToWorldMatrix = mat3(var_Tangent.xyz, var_Binormal.xyz, var_Normal.xyz);
#endif

	vec2 texDiffuse = var_TexDiffuse.st;

#if defined(gfx_NormalMapping)
	vec2 texNormal = var_TexNormal.st;

	vec2 texSpecular = var_TexSpecular.st;
#endif  

	vec4 diffuse = texture2D(u_DiffuseMap, texDiffuse);
	if(u_AlphaTest == ATEST_GT_0 && diffuse.a <= 0.0)
	{
		discard;
		return;
	}
	else if(u_AlphaTest == ATEST_LT_128 && diffuse.a >= 0.5)
	{
		discard;
		return;
	}
	else if(u_AlphaTest == ATEST_GE_128 && diffuse.a < 0.5)
	{
		discard;
		return;
	}

#if defined(gfx_NormalMapping)
	 
	vec3 N = 2.0 * (texture2D(u_NormalMap, texNormal).xyz - 0.5);
	 
	#if defined(gfx_NormalScale)
	N.z *= gfx_NormalScale;
	#endif

	N = normalize(N);

	 
	N = tangentToWorldMatrix * N;

	vec3 specular = texture2D(u_SpecularMap, texSpecular).rgb;

#else
	vec3 N;
	if(gl_FrontFacing)
		N = -normalize(var_Normal.xyz);
	else
		N = normalize(var_Normal.xyz);
#endif

	 
	N = N * 0.5 + 0.5;

	gl_FragData[0] = vec4(diffuse.rgb, 0.0);
	gl_FragData[1] = vec4(N, 0.0);
#if defined(gfx_NormalMapping)
	gl_FragData[2] = vec4(specular, 0.0);
#endif
}
