attribute vec4		attr_Position;
attribute vec4		attr_TexCoord0;
attribute vec3		attr_Tangent;
attribute vec3		attr_Binormal;
attribute vec3		attr_Normal;
attribute vec4		attr_Color;
attribute vec4		attr_Position2;
attribute vec3		attr_Tangent2;
attribute vec3		attr_Binormal2;
attribute vec3		attr_Normal2;
attribute vec4		attr_BoneIndexes;
attribute vec4		attr_BoneWeights;
uniform int			u_VertexSkinning;
uniform mat4		u_BoneMatrix[MAX_GLSL_BONES];
uniform float		u_VertexInterpolation;
uniform mat4		u_DiffuseTextureMatrix;
uniform mat4		u_NormalTextureMatrix;
uniform mat4		u_SpecularTextureMatrix;
uniform vec4		u_ColorModulate;
uniform vec4		u_Color;
uniform mat4		u_ModelMatrix;
uniform mat4		u_ModelViewProjectionMatrix;
uniform float		u_Time;
varying vec4		var_Position;
varying vec2		var_TexDiffuse;
#if defined(USE_NORMAL_MAPPING)
varying vec2		var_TexNormal;
#if !defined(gfx_DeferredLighting)
varying vec2		var_TexSpecular;
#endif
varying vec3		var_Tangent;
varying vec3		var_Binormal;
#endif
varying vec3		var_Normal;
varying vec4		var_Color;

void	main()
{
	vec4 position;
	vec3 tangent = vec3(0.0);
	vec3 binormal = vec3(0.0);
	vec3 normal = vec3(0.0);

#if defined(USE_VERTEX_SKINNING)
	{
		position = vec4(0.0);

		for(int i = 0; i < 4; i++)
		{
			int boneIndex = int(attr_BoneIndexes[i]);
			float boneWeight = attr_BoneWeights[i];
			mat4  boneMatrix = u_BoneMatrix[boneIndex];

			position += (boneMatrix * attr_Position) * boneWeight;

			#if defined(USE_NORMAL_MAPPING)
			tangent += (boneMatrix * vec4(attr_Tangent, 0.0)).xyz * boneWeight;
			binormal += (boneMatrix * vec4(attr_Binormal, 0.0)).xyz * boneWeight;
			#endif

			normal += (boneMatrix * vec4(attr_Normal, 0.0)).xyz * boneWeight;
		}
	}
#elif defined(USE_VERTEX_ANIMATION)
	{
		if(u_VertexInterpolation > 0.0)
		{
			#if defined(USE_NORMAL_MAPPING)
			VertexAnimation_P_TBN(	attr_Position, attr_Position2,
									attr_Tangent, attr_Tangent2,
									attr_Binormal, attr_Binormal2,
									attr_Normal, attr_Normal2,
									u_VertexInterpolation,
									position, tangent, binormal, normal);
			#else
			VertexAnimation_P_N(attr_Position, attr_Position2,
								attr_Normal, attr_Normal2,
								u_VertexInterpolation,
								position, normal);
			#endif
		}
		else
		{
			position = attr_Position;

			#if defined(USE_NORMAL_MAPPING)
			tangent = attr_Tangent;
			binormal = attr_Binormal;
			#endif

			normal = attr_Normal;
		}
	}
#else
	{
		position = attr_Position;

		#if defined(USE_NORMAL_MAPPING)
		tangent = attr_Tangent;
		binormal = attr_Binormal;
		#endif

		normal = attr_Normal;
	}
#endif

#if defined(USE_DEFORM_VERTEXES)
	position = DeformPosition2(	position,
								normal,
								attr_TexCoord0.st,
								u_Time);
#endif

	gl_Position = u_ModelViewProjectionMatrix * position;

	var_Position = (u_ModelMatrix * position).xyzw;

#if defined(USE_NORMAL_MAPPING)
	var_Tangent.xyz = (u_ModelMatrix * vec4(tangent, 0.0)).xyz;
	var_Binormal.xyz = (u_ModelMatrix * vec4(binormal, 0.0)).xyz;
#endif

	var_Normal.xyz = (u_ModelMatrix * vec4(normal, 0.0)).xyz;

	 
	var_TexDiffuse.xy = (u_DiffuseTextureMatrix * attr_TexCoord0).st;

#if defined(USE_NORMAL_MAPPING)
	 
	var_TexNormal.xy = (u_NormalTextureMatrix * attr_TexCoord0).st;

#if !defined(gfx_DeferredLighting)
	 
	var_TexSpecular = (u_SpecularTextureMatrix * attr_TexCoord0).st;
#endif

#endif

	 
	var_Color = attr_Color * u_ColorModulate + u_Color;
}
