attribute vec4		attr_Position;
attribute vec3		attr_Normal;
attribute vec4		attr_TexCoord0;
attribute vec4		attr_Position2;
attribute vec3		attr_Normal2;
attribute vec4		attr_BoneIndexes;
attribute vec4		attr_BoneWeights;
uniform int			u_VertexSkinning;
uniform mat4		u_BoneMatrix[MAX_GLSL_BONES];
uniform float		u_VertexInterpolation;
uniform float		u_Time;
uniform mat4		u_NormalTextureMatrix;
uniform mat4		u_ProjectionMatrixTranspose;
uniform mat4		u_ModelViewMatrixTranspose;
uniform mat4		u_ModelViewProjectionMatrix;
uniform float		u_DeformMagnitude;
varying vec2		var_TexNormal;
varying float		var_Deform;

void	main()
{
	vec4            deformVec;
    float           d1, d2;	

	vec4 position = vec4(0.0);
	vec3 normal = vec3(0.0);

#if defined(USE_VERTEX_SKINNING)
	{
		for(int i = 0; i < 4; i++)
		{
			int boneIndex = int(attr_BoneIndexes[i]);
			float boneWeight = attr_BoneWeights[i];
			mat4  boneMatrix = u_BoneMatrix[boneIndex];

			position += (boneMatrix * attr_Position) * boneWeight;
			normal += (boneMatrix * vec4(attr_Normal, 0.0)).xyz * boneWeight;
		}
	}
#elif defined(USE_VERTEX_ANIMATION)
	{
		if(u_VertexInterpolation > 0.0)
		{
			VertexAnimation_P_N(attr_Position, attr_Position2,
								attr_Normal, attr_Normal2,
								u_VertexInterpolation,
								position, normal);
		}
		else
		{
			position = attr_Position;
			normal = attr_Normal;
		}
	}
#else
	{
		position = attr_Position;
		normal = attr_Normal;
	}
#endif

#if defined(USE_DEFORM_VERTEXES)
	position = DeformPosition2(	position,
								normal,
								attr_TexCoord0.st,
								u_Time);
#endif

	gl_Position = u_ModelViewProjectionMatrix * position;

	 
	deformVec = vec4(1, 0, 0, 1);
	deformVec.z = dot(u_ModelViewMatrixTranspose[2], position);

	 
	var_TexNormal = (u_NormalTextureMatrix * attr_TexCoord0).st;

	d1 = dot(u_ProjectionMatrixTranspose[0],  deformVec);
    d2 = dot(u_ProjectionMatrixTranspose[3],  deformVec);

	 
	var_Deform = min(d1 * (1.0 / max(d2, 1.0)), 0.02) * u_DeformMagnitude;
}
