uniform sampler2D	u_DepthMap;
uniform sampler2D	u_AttenuationMapXY;
uniform sampler2D	u_AttenuationMapZ;
uniform samplerCube	u_ShadowMap;
uniform vec3		u_ViewOrigin;
uniform vec3		u_LightOrigin;
uniform vec3		u_LightColor;
uniform float		u_LightRadius;
uniform float       u_LightScale;
uniform mat4		u_LightAttenuationMatrix;
uniform int			u_ShadowCompare;
uniform mat4		u_UnprojectMatrix;

varying vec2		var_TexDiffuse;
varying vec3		var_TexAttenXYZ;

void	main()
{
	vec2 st = gl_FragCoord.st * gfx_FBufScale;
	st *= gfx_NPOTScale;
	 
	float depth = texture2D(u_DepthMap, st).r;
	vec4 P = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depth, 1.0);
	P.xyz /= P.w;
	 
	vec3 R = normalize(P.xyz - u_ViewOrigin);
	float traceDistance = distance(P.xyz, u_ViewOrigin);
	traceDistance = clamp(traceDistance, 0.0, 2500.0);
	vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
	int steps = int(min(traceDistance, 2000.0));	 
	float stepSize = 64.0;

	for(float tracedDistance = 0.0; tracedDistance < traceDistance; tracedDistance += stepSize)
	{
		 
		 
		vec3 T = u_ViewOrigin + (R * tracedDistance);

		 
		vec3 texAttenXYZ		= (u_LightAttenuationMatrix * vec4(T, 1.0)).xyz;
		vec3 attenuationXY		= texture2D(u_AttenuationMapXY, texAttenXYZ.xy).rgb;
		vec3 attenuationZ		= texture2D(u_AttenuationMapZ, vec2(texAttenXYZ.z, 0)).rgb;

		float shadow = 1.0;

		#if defined(VSM)
		if(bool(u_ShadowCompare))
		{
			vec3 I2 = T - u_LightOrigin;
			vec4 shadowMoments = textureCube(u_ShadowMap, I2);
			
			#if defined(VSM_CLAMP)
			shadowMoments = 0.5 * (shadowMoments + 1.0);
			#endif
			
			float shadowDistance = shadowMoments.r;
			float shadowDistanceSquared = shadowMoments.g;

			const float	SHADOW_BIAS = 0.001;
			float vertexDistance = length(I2) / u_LightRadius - SHADOW_BIAS;

			 
			shadow = vertexDistance <= shadowDistance ? 1.0 : 0.0;

			 
			float E_x2 = shadowDistanceSquared;
			float Ex_2 = shadowDistance * shadowDistance;

			 
			float variance = min(max(E_x2 - Ex_2, 0.0) + VSM_EPSILON, 1.0);

			float mD = shadowDistance - vertexDistance;
			float mD_2 = mD * mD;
			float p = variance / (variance + mD_2);

			color.rgb += attenuationXY * attenuationZ * max(shadow, p);
		}

		if(shadow <= 0.0)
		{
			continue;
		}
		else
		#endif
		{
			color.rgb += attenuationXY * attenuationZ;
		}
	}

	color.rgb /= float(steps);
	color.rgb *= u_LightColor;
	gl_FragColor = color;
}
