uniform sampler2D	u_CurrentMap;
uniform sampler2D	u_PortalMap;
uniform sampler2D	u_DepthMap;
uniform sampler2D	u_NormalMap;
uniform vec3		u_ViewOrigin;
uniform float		u_FogDensity;
uniform vec3		u_FogColor;
uniform float		u_RefractionIndex;
uniform float		u_FresnelPower;
uniform float		u_FresnelScale;
uniform float		u_FresnelBias;
uniform float		u_NormalScale;
uniform mat4		u_ModelMatrix;
uniform mat4		u_UnprojectMatrix;

varying vec3		var_Position;
varying vec2		var_TexNormal;
varying vec3		var_Tangent;
varying vec3		var_Binormal;
varying vec3		var_Normal;
varying vec4		var_LightColor;
varying vec3		var_LightDirection;

void	main()
{
	 
	vec3 I = normalize(u_ViewOrigin - var_Position);

	mat3 tangentToWorldMatrix;
	if(gl_FrontFacing)
		tangentToWorldMatrix = mat3(-var_Tangent.xyz, -var_Binormal.xyz, -var_Normal.xyz);
	else
		tangentToWorldMatrix = mat3(var_Tangent.xyz, var_Binormal.xyz, var_Normal.xyz);

	mat3 worldToTangentMatrix;
#if defined(GLHW_ATI) || defined(GLHW_ATI_DX10) || defined(GLDRV_MESA)
	worldToTangentMatrix = mat3(tangentToWorldMatrix[0][0], tangentToWorldMatrix[1][0], tangentToWorldMatrix[2][0],
								tangentToWorldMatrix[0][1], tangentToWorldMatrix[1][1], tangentToWorldMatrix[2][1], 
								tangentToWorldMatrix[0][2], tangentToWorldMatrix[1][2], tangentToWorldMatrix[2][2]);
#else
	worldToTangentMatrix = transpose(tangentToWorldMatrix);
#endif

	vec2 texScreen = gl_FragCoord.st * gfx_FBufScale * gfx_NPOTScale;
	vec2 texNormal = var_TexNormal.st;

	 

	vec3 N = normalize(var_Normal);

	vec3 N2 = 2.0 * (texture2D(u_NormalMap, texNormal).xyz - 0.5);
	N2 = tangentToWorldMatrix * N2;

	 
	float fresnel = clamp(u_FresnelBias + pow(1.0 - dot(I, N), u_FresnelPower) * 
			u_FresnelScale, 0.0, 1.0);

	texScreen += u_NormalScale * N2.xy;

	vec3 refractColor = texture2D(u_CurrentMap, texScreen).rgb;
	vec3 reflectColor = texture2D(u_PortalMap, texScreen).rgb;

	vec4 color;

	color.rgb = mix(refractColor, reflectColor, fresnel);
	color.a = 1.0;

	if(u_FogDensity > 0.0)
	{
		 
		float depth = texture2D(u_DepthMap, texScreen).r;
		vec4 P = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depth, 1.0);
		P.xyz /= P.w;

		 
		float fogDistance = distance(P.xyz, var_Position);

		 
		float fogExponent = fogDistance * u_FogDensity;

		 
		float fogFactor = exp2(-abs(fogExponent));

		color.rgb = mix(u_FogColor, color.rgb, fogFactor);
	}

	vec3 L = normalize(var_LightDirection);

	 
	vec3 H = normalize(L + I);

	 
	vec3 light = var_LightColor.rgb * clamp(dot(N2, L), 0.0, 1.0);

	 
	vec3 specular = reflectColor * var_LightColor.rgb * pow(clamp(dot(N2, H), 0.0, 1.0), gfx_SpecularExponent) * gfx_SpecularScale;
	color.rgb += specular;

	gl_FragColor = color;
}
