attribute vec4		attr_Position;
attribute vec4		attr_TexCoord0;
attribute vec3		attr_Tangent;
attribute vec3		attr_Binormal;
attribute vec3		attr_Normal;
attribute vec4		attr_Color;
attribute vec3		attr_LightDirection;
uniform mat4		u_NormalTextureMatrix;
uniform mat4		u_ModelMatrix;
uniform mat4		u_ModelViewProjectionMatrix;
varying vec3		var_Position;
varying vec2		var_TexNormal;
varying vec3		var_Tangent;
varying vec3		var_Binormal;
varying vec3		var_Normal;
varying vec4		var_LightColor;
varying vec3		var_LightDirection;

void	main()
{
	gl_Position = u_ModelViewProjectionMatrix * attr_Position;
	var_Position = (u_ModelMatrix * attr_Position).xyz;
	var_TexNormal = (u_NormalTextureMatrix * attr_TexCoord0).st;
	var_Tangent.xyz = (u_ModelMatrix * vec4(attr_Tangent, 0.0)).xyz;
	var_Binormal.xyz = (u_ModelMatrix * vec4(attr_Binormal, 0.0)).xyz;	 
	var_Normal = (u_ModelMatrix * vec4(attr_Normal, 0.0)).xyz;
	var_LightColor = attr_Color;
	var_LightDirection = attr_LightDirection;
}
