uniform sampler2D	u_ColorMap;
uniform sampler2D	u_DepthMap;
uniform vec3        u_blurVec;

void	main()
{
	vec2 st = gl_FragCoord.st;
	vec4 color = vec4( 0.0 );

	st *= gfx_FBufScale;

	st *= gfx_NPOTScale;

	float depth = texture2D( u_DepthMap, st ).r;

	if( depth >= 1.0 ) 
	{
		discard;
		return;
	}
	
	depth /= 1.0 - depth;

	vec3 start = vec3(st * 2.0 - 1.0, 1.0) * depth;
	vec3 end   = start + u_blurVec.yzx;

	for( int i = 0; i < 11; i ++ ) 
	{
		vec3 pos = mix( start, end, float(i) * 0.1 );
		pos /= pos.z;
		color += texture2D( u_ColorMap, 0.5 * pos.xy + 0.5 );
    }

	gl_FragColor = color / 11.0;
}
