
 

uniform sampler2D	u_ColorMap;
uniform float		u_BlurMagnitude;

void	main()
{
	vec2 st00 = gl_FragCoord.st;

	st00 *= gfx_FBufScale;

	st00 *= gfx_NPOTScale;

	 
	 
	vec2 deform = u_BlurMagnitude * gfx_FBufScale;

	 
	vec2 offset01 = vec2(-0.5, -0.5);
	vec2 offset02 = vec2(-0.5,  0.0);
	vec2 offset03 = vec2(-0.5,  0.5);
	vec2 offset04 = vec2( 0.5, -0.5);
	vec2 offset05 = vec2( 0.5,  0.0);
	vec2 offset06 = vec2( 0.5,  0.5);
	vec2 offset07 = vec2( 0.0, -0.5);
	vec2 offset08 = vec2( 0.0,  0.5);

	 
	vec2 st01 = st00 + offset01 * deform;
	vec2 st02 = st00 + offset02 * deform;
	vec2 st03 = st00 + offset03 * deform;
	vec2 st04 = st00 + offset04 * deform;
	vec2 st05 = st00 + offset05 * deform;
	vec2 st06 = st00 + offset06 * deform;
	vec2 st07 = st00 + offset07 * deform;
	vec2 st08 = st00 + offset08 * deform;

	 
	vec4 c00 = texture2D(u_ColorMap, st00);

	 
	vec4 c01 = texture2D(u_ColorMap, st01);
	vec4 c02 = texture2D(u_ColorMap, st02);
	vec4 c03 = texture2D(u_ColorMap, st03);
	vec4 c04 = texture2D(u_ColorMap, st04);
	vec4 c05 = texture2D(u_ColorMap, st05);
	vec4 c06 = texture2D(u_ColorMap, st06);
	vec4 c07 = texture2D(u_ColorMap, st07);
	vec4 c08 = texture2D(u_ColorMap, st08);

	 
	vec4 xedge = c02 * 2.0 - c05 * 2.0;
	vec4 yedge = c07 * 2.0 - c08 * 2.0;

	xedge = xedge + c01 + c03 - c04 - c06;
	yedge = yedge + c01 - c03 + c04 - c06;

	 
	xedge *= xedge;
	yedge *= yedge;

	vec4 tmp = xedge + yedge;
	tmp.x = max(tmp.x, tmp.y);
	tmp.x = max(tmp.x, tmp.z);

	 
	vec4 sobel = vec4(pow(tmp.x, 0.5), 0, 0, 0);

	 
	 
	 
	vec4 hue;

	 
	hue.x = c00.x + c00.y + c00.z;

	 
	hue.y = 1.0 / hue.x;

	 
	c00 *= hue.y;

	 
	 
	 
	 

	 
	if(hue.x >= 0.2)
		hue.z = 1.0;
	else
		hue.z = 0.0;

	 
	hue.z *= 0.5;

	 
	if(hue.x >= 0.8)
		hue.y = 1.0;
	else
		hue.y = 0.0;

	 
	hue.y *= (0.5 + 0.5);

	 
	if(hue.x >= 1.5)
		hue.x = 1.0;
	else
		hue.x = 0.0;

	 
	hue.x *= (0.5 + 0.5 + 1.5);

	 
	hue.x += hue.y + hue.z;

	 
	c00 *= hue.x;

	 
	 
	if(sobel.x < 0.8)
		sobel.x = 1.0;
	else
		sobel.x = 0.0;

	 
	 
	if(hue.x >= 2.5)
		sobel.y = 1.0;
	else
		sobel.y = 0.0;

	 
	sobel.x = max(sobel.x, sobel.y);

	 
	c00 *= sobel.x;

	 
	gl_FragColor = c00;
}
