attribute vec4		attr_Position;
attribute vec4		attr_Color;
uniform vec3		u_LightOrigin;
uniform mat4		u_ModelViewProjectionMatrix;
varying vec4		var_Color;

void	main()
{
	if(attr_Position.w == 1.0)
	{
		gl_Position = u_ModelViewProjectionMatrix * attr_Position;
	}
	else
	{
		vec4 vertex = vec4((attr_Position.xyz - u_LightOrigin), 0.0);
		gl_Position	= u_ModelViewProjectionMatrix * vertex;
	}
	
	var_Color = attr_Color;
}
