attribute vec4		attr_Position;
attribute vec3		attr_Normal;
attribute vec4		attr_TexCoord0;
attribute vec4		attr_Color;
attribute vec4		attr_Position2;
attribute vec3		attr_Normal2;
attribute vec4		attr_BoneIndexes;
attribute vec4		attr_BoneWeights;
uniform int			u_VertexSkinning;
uniform mat4		u_BoneMatrix[MAX_GLSL_BONES];
uniform float		u_VertexInterpolation;
uniform vec4		u_Color;
uniform mat4		u_ColorTextureMatrix;
uniform mat4		u_ModelMatrix;
uniform mat4		u_ModelViewProjectionMatrix;
uniform float		u_Time;
varying vec3		var_Position;
varying vec2		var_Tex;
varying vec4		var_Color;

void	main()
{
	vec4 position = vec4(0.0);
	vec3 normal = vec3(0.0);

#if defined(USE_VERTEX_SKINNING)
	{
		for(int i = 0; i < 4; i++)
		{
			int boneIndex = int(attr_BoneIndexes[i]);
			float boneWeight = attr_BoneWeights[i];
			mat4  boneMatrix = u_BoneMatrix[boneIndex];
			
			position += (boneMatrix * attr_Position) * boneWeight;
			normal += (boneMatrix * vec4(attr_Normal, 0.0)).xyz * boneWeight;
		}
	}
#elif defined(USE_VERTEX_ANIMATION)
	{
		if(u_VertexInterpolation > 0.0)
		{
			VertexAnimation_P_N(attr_Position, attr_Position2,
								attr_Normal, attr_Normal2,
								u_VertexInterpolation,
								position, normal);
		}
		else
		{
			position = attr_Position;
			normal = attr_Normal;
		}
	}
#else
	{
		position = attr_Position;
		normal = attr_Normal;
	}
#endif
	
#if defined(USE_DEFORM_VERTEXES)
	position = DeformPosition2(	position,
								normal,
								attr_TexCoord0.st,
								u_Time);
#endif


	gl_Position = u_ModelViewProjectionMatrix * position;

#if defined(LIGHT_DIRECTIONAL)
	var_Position = gl_Position.xyz / gl_Position.w;
#else
	
		var_Position = (u_ModelMatrix * position).xyz;
#endif
	
	 
	var_Tex = (u_ColorTextureMatrix * attr_TexCoord0).st;
	
	 
	var_Color = u_Color;
}
