uniform sampler2D	u_CurrentMap;
uniform float		u_HDRKey;
uniform float		u_HDRAverageLuminance;
uniform float		u_HDRMaxLuminance;
const vec4			LUMINANCE_VECTOR = vec4(0.2125, 0.7154, 0.0721, 0.0);
const vec3			BLUE_SHIFT_VECTOR = vec3(1.05, 0.97, 1.27); 

void	main()
{
	 
	vec2 st = gl_FragCoord.st * gfx_FBufScale;
	
#if defined(BRIGHTPASS_FILTER)
	st *= vec2(4.0, 4.0);
#endif
	
	 
	st *= gfx_NPOTScale;
	
	vec4 color = texture2D(u_CurrentMap, st);
	float Y = dot(LUMINANCE_VECTOR, color);
	float Yr = u_HDRKey * Y / u_HDRAverageLuminance;

	float Ymax = u_HDRMaxLuminance;

	float L = 1.0 - exp(-Yr);
	
#if !defined(BRIGHTPASS_FILTER)
		color.rgb *= L;
#endif

	gl_FragColor = color;
	
}
