uniform sampler2D	u_DepthMap;
uniform vec3		u_ViewOrigin;
uniform float		u_FogDensity;
uniform vec3		u_FogColor;
uniform mat4		u_UnprojectMatrix;

void	main()
{
	 
	vec2 st = gl_FragCoord.st * gfx_FBufScale;
	
	 
	st *= gfx_NPOTScale;
	
	 
	float depth = texture2D(u_DepthMap, st).r;
	vec4 P = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depth, 1.0);
	P.xyz /= P.w;

	 
	float fogDistance = distance(P.xyz, u_ViewOrigin);
	
	 
	float fogExponent = fogDistance * u_FogDensity;
	
	 
	float fogFactor = exp2(-abs(fogExponent));
	
	 
	gl_FragColor = vec4(u_FogColor, fogFactor);
}
