uniform sampler2D	u_DepthMap;
uniform sampler2D	u_DepthMapBack;
uniform sampler2D	u_DepthMapFront;
uniform vec3		u_ViewOrigin;
uniform float		u_FogDensity;
uniform vec3		u_FogColor;
uniform mat4		u_UnprojectMatrix;

float DecodeDepth(vec4 color)
{
	float depth;
	const vec4 bitShifts = vec4(1.0 / (256.0 * 256.0 * 256.0), 1.0 / (256.0 * 256.0), 1.0 / 256.0, 1.0);
	depth = dot(color, bitShifts);
	return depth;
}

void	main()
{
	vec2 st = gl_FragCoord.st * gfx_FBufScale;
	st *= gfx_NPOTScale;
	float fogDepth;
	float depthSolid = texture2D(u_DepthMap, st).r;
	
	float depthBack = DecodeDepth(texture2D(u_DepthMapBack, st));
	float depthFront = DecodeDepth(texture2D(u_DepthMapFront, st));

	if(depthSolid < depthFront)
	{
		discard;
		return;
	}
	
	if(depthSolid < depthBack)
	{
		depthBack = depthSolid;
	}
	
	fogDepth = depthSolid;
	
	vec4 posBack = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depthBack, 1.0);
	posBack.xyz /= posBack.w;
	
	vec4 posFront = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depthFront, 1.0);
	posFront.xyz /= posFront.w;
	
	if(posFront.w <= 0.0)
	{
		posFront = vec4(u_ViewOrigin, 1.0);
	}

	float fogDistance = distance(posBack, posFront);
	float fogExponent = fogDistance * u_FogDensity;
	float fogFactor = exp2(-abs(fogExponent));
	gl_FragColor = vec4(u_FogColor, fogFactor);
}
