
/*
All shaders used by the game for mainly 3d related stuff.
HUD (stuff drawn in 2D on screen) should be in hud.shader
Textures used are atm largely placed in sfx folder.
See no need to move it to something like gfx/3d, many of 
the textures made for stuff here could be used for other mapping-shaders as well..

blendmodes:
add
filter
modulate
overlay
blend2
blend3
dark
dark2
none
*/

_playerShadow
{
	polygonOffset
	{
		map gfx/lights/round2.png
		blend GL_ZERO, GL_ONE_MINUS_SRC_COLOR
		vertexColor
	}
}


SkinMat
{
	twoSided
	diffuseMap		 models/edmond/Skin_diffuse
	normalMap		 models/edmond/Skin_normals
	specularMap	 	 models/edmond/Skin_specular
}

clothsMat
{
	twoSided
	diffuseMap		 models/edmond/Cloths_diffuse
	normalMap		 models/edmond/Cloths_normals
	specularMap	 	 models/edmond/Cloths_specular
}

// Misc stuff
// ******************************
_nullShader // Don't change ..
{
	nowj
	surfaceparm nodraw
	surfaceparm nolightmap
	surfaceparm nomarks
	surfaceparm noimpact
	surfaceparm playerclip
}

_routeLines // todo.. Maybe with a blurred flat-ish circleshape @ 256x32 or something like that?
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		map textures/sfx/line7
		blend add
		colored
	}
}

// Trigger multiple etc
// ******************************
_trigger_multiple_ingame
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	nopicmip
	
	{
		clampmap textures/common/trigger
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.15
		rgbGen vertex
	}
}

_run_entity_start
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline13
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.2
		rgbGen const ( 0 1 0 )
	}
}

_run_entity_checkpoint
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline13
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.25
		rgbGen const ( 1 1 0 )
	}
}

_run_entity_checkpoint_nogravity_on
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline13_nogravityon
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.25
		rgbGen const ( 1 1 0 )
	}
}

_run_entity_checkpoint_nogravity_off
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline13_nogravityoff
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.25
		rgbGen const ( 1 1 0 )
	}
}

_run_entity_checkpoint_passed
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline21
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.1
		rgbGen const ( 1 1 0 )
	}
}


_run_entity_stop
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline13
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.5
		rgbGen const ( 1 0 0 )
	}
}




// Shootpoints
// ******************************
_run_shoot_red // Not so red anymore, but \care.
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline5
		//blend GL_SRC_ALPHA, GL_ONE
		blend add
		alpha 0.33
		rgbGen const ( 1 0 1 )
		//rgbGen const ( 1 0 0 )
		//rgbGen const ( 0 0.784 0.592 )
	}
	
	/*{
		clampmap _red
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.85
		rgbGen vertex
	}*/
}

_run_shoot_yellow
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline5
		//blend GL_SRC_ALPHA, GL_ONE
		blend add
		alpha 0.33
		rgbGen const ( 1 1 0 )
	}
}

_run_shoot_blue
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap textures/sfx/outline5
		blend add
		alpha 0.33
		rgbGen const ( 0 0.5 1 )
	}
}

_run_shoot_hit // after you've hit it enough times so it per default goes white..
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	nopicmip
	
	
	{
		clampmap textures/sfx/outline
		blend overlay
		alpha 0.1
		rgbGen vertex
	}
}

// Weapon HIT effects
// ******************************
_lightBallsBlue
{
	twoSided
	
	{
		map textures/sfx/light3
		blend add
		vertexColor
		alpha 0.5
	}
}


_hit_blueBalls
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	nopicmip
	
	{
		map textures/sfx/lightwhite	
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.5
		rgbGen const ( 0 0.5 1 )
	}
}

_hit_yellowBalls
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	nopicmip
	
	{
		map textures/sfx/lightwhite	
		blend GL_SRC_ALPHA, GL_ONE
		alpha 0.5
		rgbGen const ( 1 1 0 )
	}
}

_hit_redBalls
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	nopicmip
	
	{
		map textures/sfx/lightwhite	
		//blend GL_SRC_ALPHA, GL_ONE
		blend add
		alpha 0.5
		rgbGen const ( 1 0 1 )
	}
}

_hit_whiteBalls
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	nopicmip
	
	{
		clampmap textures/sfx/lightwhite
		blend overlay
		alpha 0.2
		rgbGen vertex
	}
}

// "Give" sprites ingame
_run_give_0
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/give/rocket
		blend blend
		rgbGen const(1 0 0)
		alpha 0.4
	}
}

_run_give_1
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/give/plasma
		blend blend
		rgbGen const(0 0.5 1)
		alpha 0.4
	}
}


_run_give_2
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/give/both
		blend blend
		rgbGen const(1 0 1)
		alpha 0.4
	}
}

// Onlyreset shader..
_run_give_3
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/give/reset
		blend blend
		rgbGen const(0 0 0)
		alpha 0.4
	}
}

_run_give_4 // pickup
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/give/pickup
		blend blend
		rgbGen const(0 110 190)
		alpha 0.65
	}
}

_run_give_5 // pickup, while it's waiting to respawn..
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/give/pickup
		blend blend
		rgbGen const(0 0 0)
		alpha 0.15
		tcmod rotate 350
	}
}


// The outline shaders for the actual triggers
_run_entity_give
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/give/give
		blend blend
		rgbGen vertex
	}
}

_run_entity_give_onlyreset
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/give/give
		blend blend
		rgbGen const(1 0 0)
	}
}





_playerSprite
{
	sort postProcess
	twoSided
	nomarks
	noimpact
	noshadows
	nonsolid
	trans
	
	{
		clampmap gfx/playersprite
		blend blend
		rgbGen vertex
	}
}
